/**
 * CXO_AdFunctions
 * 
 * Diese Datei stellt JavaScript Funktion
 * fuer die Werbesteuerung bereit.
 * 
 * @author apirsig
 * @since  060302
 * @changelog  060724 + Zusaetzlichen Abstand beim aufschieben des Xonio Content-Ads
 *                    + auf der Xonio Homepage (api)
 *             060302 + cxo_adfunctions.js in Werbesteuerung implementiert (api)
 *                    + Shuffle AdFunktion fuer Xonio eingebaut (api)
 */



/** 
 * getAnchorPosition(anchorname)
 *
 * This function returns an object having .x and .y properties which are the coordinates
 * of the named anchor, relative to the page.
 *
 * @author Matt Kruse <matt@mattkruse.com>
 * @changelog  + 051224  getAnchorPosition(anchorname) nach Aufruf von Vibrant Media's 
 *                       IntelliTXT began Firefox auch auf document.all zu reagieren, 
 *                       das klappt aber nicht... ergo: nun wird unter "Logic to find position" 
 *                       erst use_gebi abgefragt, und dann erst document.all (bp)
 *             + 060302  Kommentare in funktion popframe ueberarbeitet - api
 */

function getAnchorPosition(anchorname) {
	// This function will return an Object with x and y properties
	var useWindow=false;
	var coordinates=new Object();
	var x=0,y=0;
	
	// Browser capability sniffing
	var use_gebi=false, use_css=false, use_layers=false;
	if (document.getElementById) { 
		use_gebi=true; 
	} else if (document.all) { 
		use_css=true; 
	} else if (document.layers) { 
		use_layers=true; 
	}
	
	// Logic to find position
 	if (use_gebi) {
		var o=document.getElementById(anchorname);
		x=AnchorPosition_getPageOffsetLeft(o);
		y=AnchorPosition_getPageOffsetTop(o);
   } else if (document.all) {
		x=AnchorPosition_getPageOffsetLeft(document.all[anchorname]);
      y=AnchorPosition_getPageOffsetTop(document.all[anchorname]);
   } else if (use_css) {
		x=AnchorPosition_getPageOffsetLeft(document.all[anchorname]);
		y=AnchorPosition_getPageOffsetTop(document.all[anchorname]);
	} else if (use_layers) {
		var found=0;
		for (var i=0; i<document.anchors.length; i++) {
			if (document.anchors[i].name==anchorname) { 
				found=1; break; 
			}
		}
	
		if (found==0) { 
			coordinates.x=0; coordinates.y=0; return coordinates;
		}
		x=document.anchors[i].x;
		y=document.anchors[i].y;
	} else {
		coordinates.x=0; coordinates.y=0; return coordinates;
	}
	coordinates.x=x;
	coordinates.y=y;
	return coordinates;
}

/**
 * getAnchorWindowPosition(anchorname)
 *
 * This function returns an object having .x and .y properties which 
 * are the coordinates of the named anchor, relative to the window
 */

function getAnchorWindowPosition(anchorname) 
{
	var coordinates=getAnchorPosition(anchorname);
	var x=0;
	var y=0;
	
	if (document.getElementById) {
		if (isNaN(window.screenX)) {
			x=coordinates.x-document.body.scrollLeft+window.screenLeft;
			y=coordinates.y-document.body.scrollTop+window.screenTop;
		} else {
			x=coordinates.x+window.screenX+(window.outerWidth-window.innerWidth)-window.pageXOffset;
			y=coordinates.y+window.screenY+(window.outerHeight-24-window.innerHeight)-window.pageYOffset;
		}
	} else if (document.all) {
		x=coordinates.x-document.body.scrollLeft+window.screenLeft;
		y=coordinates.y-document.body.scrollTop+window.screenTop;
	} else if (document.layers) {
		x=coordinates.x+window.screenX+(window.outerWidth-window.innerWidth)-window.pageXOffset;
		y=coordinates.y+window.screenY+(window.outerHeight-24-window.innerHeight)-window.pageYOffset;
	}
	coordinates.x=x;
	coordinates.y=y;
	return coordinates;
}

/**
 * Functions for IE to get position of an object
 */
function AnchorPosition_getPageOffsetLeft (el) {
	try { 
		var ol=el.offsetLeft;
		while ((el=el.offsetParent) != null) { 
			ol += el.offsetLeft; 
		}
		return ol;
	} catch(err) { }
}
	
function AnchorPosition_getWindowOffsetLeft (el) {
	return AnchorPosition_getPageOffsetLeft(el)-document.body.scrollLeft;
}


function AnchorPosition_getPageOffsetTop (el) {
	try {
		var ot=el.offsetTop;
		while((el=el.offsetParent) != null) { 
			ot += el.offsetTop; 
		}
		return ot;
	} catch(err) { }
}
	
function AnchorPosition_getWindowOffsetTop (el) {
	return AnchorPosition_getPageOffsetTop(el)-document.body.scrollTop;
}

/**
 * Funktion zum Auswerten von GET-Parameter
 * via JavaScript
 */
function getQueryVariable(variable) {
	var query = window.location.search.substring(1);
	var vars = query.split("&");

	for (var i=0;i<vars.length;i++) {
		var Key_And_Value = vars[i].split("=");

		if (Key_And_Value[0] == variable) {
			return Key_And_Value[1];
		}
	}     
	return false;
}

/**
 * PopFrame
 *
 * Funktion um Position der Divs zu messen und
 * zu verschieben Achtung der Aufruf sollte erst ganz
 * am schluss der html-Seite kommen damit auch ja alle
 * Werbeformen gesetzt sind und positioniert werden koennen
 * 
 * @author api
 * @version 1.05
 * @changelog  + 060403 DebugModus ueberarbeitet (GET-Var auswertung und PopUp-Modus),
 *                      sowie Zaehler fuer Popframe aufrufe eingebaut (api)
 * @changelog  + 060302 in cxo_adfunctions.js eingebaut (api)
 */

/**
 * ARRAY fuer AD-Keywords initialisieren
 */
myBanner       = new Array();
popframe_count = 0;


function popframe(keyword)
{

	/**
	 * @param keyword string durch den param keyword
	 * kann von aussen einfluss genommen werden wie
	 * die Position eines Werbemittels berechnet wird
	 * das ganze ist Seitenabhaengig
	 */

	/** 
	 * Debug-Mode:
	 * 
	 * Wird als PopUp ausgegeben, (auf PopUp-Blocker achten)
	 */
	popframe_count++; 	// Zaehlt mit wie oft 
						// diese Funktion aufgerufen wurde

	fmargin_bottom = 0; // Zusaetzlicher Abstand fuer WM falls gewuenscht

	
	/**
	 * Prueft ob Debug-Info ausgegeben werden soll
	 */
	if(getQueryVariable('debug')=='on') {
		var debug = true;
	} else {
		var debug = false;
	}
	var i = 0;

	/**
	 * Beginn tatsaechlicher Messung
	 */
	while(i != myBanner.length) {

		/**
		 * Test auf Anker-ID, bei erfolg Koordinarten messen
		 */
		var o = top.document.getElementById('anchor'+myBanner[i]);
				
		if (top.document.getElementById('anchor'+myBanner[i])) {
			
			/** 
			 * Messe Abstand zur oberen und linken Fenster- 
			 * seite des Werbemittels. 
			 */
			var c = getAnchorPosition('anchor'+myBanner[i]);

			/** 
			 * Banner hoehe messen. Dieser Wert wird 
			 * benoetigt damit wie spaeter ein DIV entsprechend 
			 * vergroessern koennen.
			 */
			var ht = top.document.getElementById('table'+myBanner[i]).offsetHeight;
			var wt = top.document.getElementById('table'+myBanner[i]).offsetWidth;
				
			/**
			 * Banner liefern wenn gemessene Hoehe groesser 
			 * 20px ist
			 */
			if(ht>20) {
					
	
				/**
				 * fmargin_bottom sorgt fuer zusaetzlichen abstand bei 
				 * Contentbannern. (hma 20070703)
				 */

				 
				if(myBanner[i]  == 'CONTENTAD'){
					fmargin_bottom = 10;
				}
				
				/** 
				 * Setzt gemessene Tabellenhoehe um 2px hoch 
				 * um zusaetzlichen Abstand zu gewinnen
				 */
				
				var ht = ht+2+fmargin_bottom;
								
				/**
				 * Werbemittel verschieben
				 */
				top.document.getElementById('div'+ myBanner[i]).style.top = c.y+'px';
				top.document.getElementById('div'+ myBanner[i]).style.left = c.x+'px';
						
				/**
				 * Sollten wir gerade eine Bildergalerie Berechnen muss das Adslide
				 * Zentriert ausgerichtet werden.
				 */
				if(keyword=='bgalerie' && myBanner[i]=='ADSLIDE') {
		
					var center_pos = c.x-wt/2;
					var center_pos_wb = wt + 30;
					top.document.getElementById('div'+ myBanner[i]).style.left = center_pos+'px';
					top.document.getElementById('Anzeige').style.width = center_pos_wb+'px';
					top.document.getElementById('Anzeige').style.visibility = 'visible';
											
					/**
					 * Tabelle im DIV mit gemessener hoehe aufklappen
					 */
					top.document.getElementById('resizetable'+myBanner[i]).style.height = ht+'px';

				} else {
	
					/**
					 * Tabelle im DIV mit gemessener hoehe aufklappen
					 */
					top.document.getElementById('resizetable'+myBanner[i]).style.height = ht+'px';
				}
	
						
				/**
				 * Div sichtbar machen
				 */
				top.document.getElementById('div'+ myBanner[i]).style.visibility = 'visible';
								
			}
		}
				
		/** 
		 * Ausnahme fuer TFS:
		 * Falls myBANNER=='BANNER' ist, dieses sichtbar schalten.
		 * @internal: Da TFS FlashLayer ueber den Top-Banner ausliefert 
		 * muss dieser immer sichtbar geschalten werden
		 * api 050916
		 */
		if(myBanner[i]=='BANNER') {
			top.document.getElementById('div'+ myBanner[i]).style.visibility = 'visible';
		}
		
				
		if(debug==true) {				
			/** 
			 * DEBUG-CODE
			 *
			 * Erzeugt ein PopUp mit Debug-Info
			 */

			if(!debug_window) {
				var debug_window = window.open("","AD_DEBUG","");
				debug_window.document.open();
				debug_window.document.writeln('<pre>');
				debug_window.document.writeln('JS-AD-DEBUG-AUSGABE:');
				debug_window.document.writeln('====================');
				debug_window.document.writeln('Anz. Aufrufe Popframe: '+popframe_count);
				debug_window.document.writeln('Anz. geschaltener Werbeformen: '+myBanner.length);
				debug_window.document.writeln('</pre>');
						
			}
			
				debug_window.document.writeln('<pre>Werbemittel: '+myBanner[i]);
				debug_window.document.writeln('POS Y (TOP):    '+c.y+'px');
				debug_window.document.writeln('POS X (LEFT):   '+c.x+'px');
				debug_window.document.writeln('Werbm. Hoehe:   '+ht+'px');	
				debug_window.document.writeln('Werbm. Breite:  '+wt+'px');	
				debug_window.document.writeln('Visibility:     '+top.document.getElementById('div'+ myBanner[i]).style.visibility);
				debug_window.document.writeln('</pre>');
		}
					

		/** 
		 * Zaehler um eins erhoehen und von vorne
		 * beginnen.
		 */
		var i=i+1;
	}

	/**
	 * Schliesst das Document-Objekt um
	 * unnoetige Ladevorgaenge im Debug-PopUp
	 * zu verhindern
	 */
	if(debug==true) {
		debug_window.document.close();
	}
}


/**
 * CXO_WriteBanner(wmtype)
 * 
 * CXO_WriteBanner() schreibt den Inhalt des 
 * Assoz.-Arrays cxo_kombiwerbung anhand des ueber
 * gebenen Typs.
 *
 * Diese Funktion wird z.B. bei Kombi-ADs benoetigt
 * 
 * @author api
 * @version 1.00
 * @since 060302
 * @param wmtype String Gibt an fuer welches WM ein alternative
 *                      String geschrieben werden soll.
 *
 * <code>
 *   // BannerCode fuer Contentbanner deklarieren
 *   cxo_kombiwerbung[0]["ContentBanner"] = 'Hello Banner';
 *   
 *   // Dannach eigentliche Funktion aufrufen
 *   CXO_WriteBanner('ContentBanner');
 *   
 *  // Ergebniss in der Seite
 *  Hello Banner
 * </code>
 *
 * @changelog  + 060302  CXO_WriteBanner() in die Werbesteuerung aufgenommen (api)
 */

/**
 * Inititialisiert Globales Array mit entsprechenden
 * schluesseln.
 */
cxo_kombiwerbung    = new Array();
cxo_kombiwerbung[0] = new Object();
cxo_kombiwerbung[0]["TopBanner"]     = '';
cxo_kombiwerbung[0]["ContentBanner"] = '';


function CXO_WriteBanner(wmtype) {
	/**
	 * Schreibt KombiSource
	 */
	if(cxo_kombiwerbung[0][wmtype].length > 0) {
		document.write(cxo_kombiwerbung[0][wmtype]);
		return true;
	}
}


/**
 * Funktionen fuer die Shuffle-Ad-Auslieferung
 *
 * Versucht den Source eines IFrames anhand
 * der ID auf den Parameter SrcAdress zusetzen
 *
 * @param IFrameID  String Id des anzusprechenden Iframes
 * @param SrcAdress String Src-Ad. z.B. http://www.chip.de
 * 
 * @changelog  + 060306 ShuffleAdSrc Funktion fuer Xonio implementiert (api)
 */
function CXO_ShuffleAdSrc(IFrameId,SrcAdress) {
	try {
		document.getElementById(IFrameId).src = SrcAdress;
	}
	catch (e){
	}
	finally {
	}
	return true;
}


// ##############################################################
// AB HIER OUTDATED - Funktionen die nicht benutzt werden (tests)
// ##############################################################


/**
 * Funktionssammlung fuer Kombibanner. Um Werbemittel
 * nachtraeglich zu laden
 *
 * @author api
 * @since 05-10-19
 * @version 1.0
 * @copyright CHIP Xonio Online GmbH
 *
 * Testet auf vorhanden Sein einer ID
 * falls diese vorhanden ist, wird Sourcecode
 * an der Stelle des Funktionsaufrufs geschrieben
 *
 * @param Zaehler INT Zaehlt Durchlaufe
 * @param id String Element-ID nach der gesucht wird
 * @param bannersource String Source der bei erfolg geschrieben wird
 * @internal die Funktion setzt voraus das das Element 
 *           ueber ein Source-Attribute verfuegt
 *
 * [code]
 *     test_id(0,'testid','source-2-write');
 * [/code]
 */


function pausecomp(millis)
{
	date = new Date();
	var curDate = null;

	do { var curDate = new Date(); }
	while(curDate-date < millis);
} 


function test_id (id,bannersource)
{

//	var timeout     = 50; // Wartezeit zwischen durchlaeufen (MS)
//	var durchlaeufe = 100; // Max. Durchlaufe nach den abgebrochen wird

	pausecomp(2000);

	/**
	 * Da es zu JS-Fehlern fuert falls die ID nicht vorhanden ist
	 * wird versucht diese mit Try-Catch abzufangen
	 */

	try
	{
		/**
		 * Wenn Source groesser null ist melde
		 * erfolg und schreibe Banner
		 */
		if (document.getElementById(id).src < 0)
		{
			throw 'nein';
		}
		else
		{
			throw 'ja';
		}
	}
	catch (e)
	{
		if (e=='ja')
		{
//			alert('mab'+docIsLoadedByString);
//				alert('sdfa'+top.document.onload+'docIsLoaded'+docIsLoaded);	
//				document.write(bannersource);
				return true;
		}
	}
	finally
	{
	}

	return false;
}
